" Vim syntax file
" Language:    C
" Maintainer:  JoungKyun.Kim <joungkyun.kim@navercorp.com>
" Last Change: 2020.06.15

" Quit when a (custom) syntax file was already loaded
if exists("b:current_syntax")
    finish
endif

if !exists("c_no_c99") " ISO C99
	syn keyword cType _Bool bool my_bool _Complex complex _Imaginary imaginary
    syn keyword cNumber   true false
endif

if !exists("c_no_ansi") || exists("c_ansi_constants") || exists("c_gnu")
	syn keyword cConstant HUGE_VAL CLOCKS_PER_SEC
	syn keyword cString NULL
	syn keyword cConstant TMP_MAX
	syn keyword cString   stderr stdin stdout
endif

" OOPS Patch
syn keyword cType      __int32 __int64 longlong
syn keyword cType      int8 int16 int32 int64 int128
syn keyword cType      uint uint8 uint16 uint32 uint64 uint128
syn keyword cType      uchar ushort cchar llong uint ulong
syn keyword cType      Long Long32 Long64 ULong ULong32 ULong64
syn keyword cType      UCChar UChar CChar UShort UInt UINT Bit64
syn keyword cType      CShort UCShort CInt UCInt uint128_t int128_t
syn keyword cType      WORD WSADATA DWORD
syn keyword cStructure CStruct
syn keyword cConstant  IPCALC_WSACleanup PLUGIN_DATA
syn match   cStructure display "[A-Z][A-Za-z0-9_]*_API"
syn keyword cString    null FAILURE TRUE FALSE SUCCESS
syn match   cConstant  display "[A-Z_]\+_U\?VERSION"
syn match   cConstant  display "PACKAGE_[A-Z]\+"
syn match   cConstant  display "AF_[A-Z]\+[0-9]*"
syn match   cConstant  display "NI_[A-Z]\+[0-9]*"

" iconv
syn keyword cType      iconv_t iconv_s

" lighttpd
syn keyword cStructure plugin_config plugin_data server buffer
syn match   cConstant  display "HANDLER_[A-Z_]\+"
syn match   cConstant  display "T_CONFIG_[A-Z_]\+"
syn keyword cConstant  CONST_STR_LEN DEFAULT_SERVER_CHARSET DEFAULT_CLIENT_CHARSET
syn keyword cString    URL_ICONV_TRUE URL_ICONV_FALSE URL_TRUE URL_FALSE

" apache
syn keyword cStructure urlconfig request_rec apr_pool_t server_rec cmd_parms
syn keyword cConstant  AP_MODULE_DECLARE_DATA DECLINED OK HTTP_MOVED_PERMANENTLY REDURL_LOG_MARK
syn match   cConstant  display "AP_INIT_[A-Z0-9_]\+"
syn match   cConstant  display "APLOG_[A-Z0-9_]\+"
syn match   cConstant  display "APR_[A-Z0-9_]\+"
syn keyword cString    REDURL_ICONV_TRUE REDURL_ICONV_FALSE

" mysql UDF
syn keyword cStructure UDF_INIT KEYINSTANCE UDF_ARGS
syn keyword cConstant  C_MODE_START C_MODE_END
syn keyword cConstant  DEBUG_FUNCTION_IN DEBUG_FUNCTION_OUT DEBUG_SUB_FUNCTION_IN DEBUG_SUB_FUNCTION_OUT
syn keyword cConstant  AES_KEY_LENGTH AES256_BLOCK_SIZE AES256_BAD_DATA AES_MAXKC AES_MAXKB AES_MAXNR

" PHP
syn keyword cType      zval pval zend_string zend_long zend_bool zend_uchar zend_array
syn keyword cType      zend_object zend_object_value zend_resource zend_reference
syn keyword cType      zend_ast_ref zend_object_handlers zend_execute_data zend_function
syn keyword cType      zend_function_entry zend_class_entry zend_value zend_module_entry
syn keyword cType      zend_module_dep zend_error_handling zend_ulong
syn keyword cType      php_socket php_socket_t php_stream php_process_env_t pid_t
syn keyword cType      HANDLE BOOL php_file_descriptor_t php_process_id_t
syn match   cType      display "zend_objects_[a-z_]\+_t"
syn keyword cStructure PHPAPI HashPosition HashTable Bucket
syn keyword cConstant  CONST_PERSISTENT CONST_CS
syn keyword cConstant  STANDARD_MODULE_HEADER STANDARD_MODULE_HEADER_EX STANDARD_MODULE_PROPERTIES
syn keyword cConstant  OnUpdateString INIT_FUNC_ARGS_PASSTHRU UNREGISTER_INI_ENTRIES
syn keyword cString    RETURN_TRUE RETURN_FALSE
syn match   cConstant  display "ZEND_[A-Z_]\+"
syn match   cConstant  display "PHP_[A-Z_]\+"
syn match   cConstant  display "[A-Z]\+_[A-Z]\+_ERROR_HANDLING"
syn match   cConstant  display "TSRM[A-Z_]\+"
syn match   cConstant  display "ZEND_ACC_[A-Z]\+"
syn match   cConstant  display "E_\(USER_\)\?\(WARNING\|ERROR\|DEPRECATED\)"
syn keyword cConstant  ZEND_HASH_APPLY_REMOVE ZEND_HASH_APPLY_KEEP EH_THROW EH_NORMAL
syn keyword cConstant  PRINT_CALL_API_NAME GE_PRINT_CALL_API_NAME
syn keyword cConstant  CHARDET_ICU CHARDET_MOZ CHARDET_PY CHARDET_VERSION U_ICU_VERSION PY_CHARDET_VERSION

" Python
syn keyword cStructure PyObject Py_ssize_t PyCFunction PyVarObject Universal
syn keyword cConstant  PyModuleDef_HEAD_INIT PyObject_HEAD
syn keyword cConstant  DETECTOR_FALSE ENCODING_LENGTH PyExc_ValueError Py_RETURN_TRUE Py_RETURN_FALSE
syn keyword cConstant  MOD_ERROR_VAL MOD_SUCCESS_VAL Py_INCREF Py_DECREF
syn match   cConstant  display "T_[A-Z]\+"
syn keyword cString    Py_None

" libchardet & ICPU
syn keyword cStructure DetectObj Detect Detector
syn keyword cStructure CharDetObj chardet_obj CharDetFP
syn keyword cStructure UCharsetDetector UCharsetMatch UErrorCode
syn keyword cConstant  CHARDET_ICU CHARDET_MOZ CHARDET_PY
syn keyword cConstant  CHARDET_OUT_OF_MEMORY CHARDET_NULL_OBJECT CHARDET_SUCCESS CHARDET_NO_RESULT CHARDET_BINARY_SAFE

" libkrisp
syn keyword cStructure KRNET_RANGE KRNET_REQ_RANGE KRNET_API_EX KROBJ

"libgeoip
syn keyword cStructure geoip_object GeoIPRecord GeoIP

