" checksyntax.vim -- Check syntax when saving a file (php, ruby, tex ...)
" @Author:      Tom Link (micathom AT gmail com)
" @License:     GPL (see http://www.gnu.org/licenses/gpl.txt)
" @Created:     04-Mai-2005.
" @Last Change: 2017-04-05.
" GetLatestVimScripts: 1431 0 :AutoInstall: checksyntax.vim
" @Revision:    469

if exists('g:loaded_checksyntax')
    finish
endif
let g:loaded_checksyntax = 500


if !exists('g:checksyntax')
    let g:checksyntax = {}
endif


" :display: CheckSyntax[!] [NAME] [PREFERRED_RX]
" Check the current buffer's syntax (type defaults to &filetype).
" Or use NAME instead of &filetype.
"
" With the bang !, run all alternatives (see 
" |g:checksyntax#run_alternatives|).
command! -bang -nargs=* CheckSyntax call checksyntax#Check(1, "<bang>", <f-args>)


command! -range -bar -nargs=? Checksyntaxfix call checksyntax#Fix(<line1>, <line2>, <q-args>)


if !exists('g:checksyntax_key_single')
    " Map for running the preferred syntax checkers on the current 
    " buffer.
    let g:checksyntax_key_single = '<F5>'   "{{{2
	let g:checksyntax_lclose = '<F6>'
endif


if !exists('g:checksyntax_key_all')
    " Map for running all suitable syntax checkers on the current 
    " buffer.
    let g:checksyntax_key_all = '<C-F5>'   "{{{2
endif


if !exists('g:checksyntax_key_quickfix')
    let g:checksyntax_key_quickfix = '<Leader>cf'   "{{{2
endif


if !exists('g:checksyntax_auto')
    " If 1, enable automatic syntax checks after saving a file.
    " If 2, enable automatic syntax checks when saving and loading a 
    " file.
    " NOTE: This variable must be customized in vimrc before loading 
    " this plugin.
    "
    " See also |g:checksyntax|, |g:checksyntax#auto_enable_rx| and 
    " |g:checksyntax#auto_disable_rx|.
    let g:checksyntax_auto = 1   "{{{2
endif

if !exists("g:checksyntax#checkwrite")
	let g:checksyntax#checkwrite = 0
endif

if !exists("g:checksyntax#movewindow")
	g:checksyntax#movewindow = 0
endif

" @TPluginInclude
augroup CheckSyntax
    autocmd!
    autocmd VimLeave * let s:vimleave = 1
    if !exists('g:checksyntax_auto') || g:checksyntax_auto >= 1
        autocmd BufWritePost * if !exists('s:vimleave') | call checksyntax#Check(g:checksyntax#postwrite) | endif
    endif
    if exists('g:checksyntax_auto') && g:checksyntax_auto >= 2
        autocmd BufEnter * if !exists('b:checksyntax_runs') && !exists('s:vimleave')
                    \ | call checksyntax#Check(0, 0, &ft)
                    \ | endif
    endif
    autocmd Syntax * call checksyntax#SetupSyntax(expand('<amatch>'))
augroup END


" @TPluginInclude
if !hasmapto(':CheckSyntax')
    if empty(maparg(g:checksyntax_key_single, 'n'))
        exec 'noremap' g:checksyntax_key_single ':CheckSyntax<cr>'
    endif
    if empty(maparg(g:checksyntax_key_single, 'i'))
        exec 'inoremap' g:checksyntax_key_single '<c-o>:CheckSyntax<cr>'
    endif
    if empty(maparg(g:checksyntax_lclose, 'n'))
        exec 'noremap' g:checksyntax_lclose ':lclose<cr>'
    endif
    if empty(maparg(g:checksyntax_lclose, 'i'))
        exec 'inoremap' g:checksyntax_lclose '<c-o>:lclose<cr>'
    endif
    if empty(maparg(g:checksyntax_key_all, 'n'))
        exec 'noremap' g:checksyntax_key_all ':CheckSyntax!<cr>'
    endif
    if empty(maparg(g:checksyntax_key_all, 'i'))
        exec 'inoremap' g:checksyntax_key_all '<c-o>:CheckSyntax!<cr>'
    endif
    if empty(maparg(g:checksyntax_key_quickfix, 'n')) && !empty(g:checksyntax_key_quickfix)
        exec 'noremap' g:checksyntax_key_quickfix ':Checksyntaxfix<cr>'
    endif
endif

