# for Navix WSL user environments

function dir-source () {
	local p="${1}"
	local rc

	[[ -z ${p} ]] && return 0
	[[ ! -d ${p} ]] && return 0

	for rc in ${p}/*
	do
		[[ -f ${rc} ]] && source "${rc}"
	done
}

# WSL distro name dist
if [[ -n ${WSL_DISTRO_NAME} ]]; then
	if [[ -f /mnt/wslg/distro.txt ]]; then
		A="$( cat /mnt/wslg/distro.txt 2> /dev/null )"
		[[ -z ${A} ]] && rm -f /mnt/wslg/distro.txt
		unset A
	fi
	[[ ! -f /mnt/wslg/distro.txt  ]] && {
		echo "${WSL_DISTRO_NAME}" > /mnt/wslg/distro.txt 2> /dev/null
		chmod 666 /mnt/wslg/distro.txt >& /dev/null
	}
else
	[[ -f /mnt/wslg/distro.txt ]] && {
		WSL_DISTRO_NAME="$( < /mnt/wslg/distro.txt )"
		export WSL_DISTRO_NAME
	}
fi

# source Navix user environments

dir-source /usr/share/Navix-WSL
dir-source ~/.bashrc.d
unset dir-source
