#
# First Login Environment Configuration Script for WSL Import Environment
#

# {{{ function spinner ()
SPINNER_CHAR=( '|' '/' '-' '\' )
function spinner () {
	local pid=$1
	local delay=0.75
	local i=0 x

	# pid 값이 없을 경우, 전역 변수 SPINNER_V 가 1로 설정이 되어 있으면
	# spinner 를 동작시킨다.
	[[ -z ${pid} ]] && {
		if (( SPINNER_V == 1 )); then
			printf "%b[%c]%b" "${green}" "${SPINNER_CHAR[SPINNER_i++]}" "${normal}"
			sleep ${delay}
			(( SPINNER_i > 3 )) && SPINNER_i=0
			printf "\b\b\b"
		else
			printf "   \b\b\b"
			unset SPINNER_i SPINNER_V
		fi
		return 0
	}

	# pid 가 -1 이면 background job process 를 체크한다.
	[[ ${pid} == "-1" ]] && pids=( $( jobs -p ) ) || pids=( ${pid} )

	for x in "${pids[@]}"
	do
		while [[ -d "/proc/${x}" ]]
		do
			printf "%b[%c]%b" "${green}" "${SPINNER_CHAR[i++]}" "${normal}"
			sleep ${delay}
			(( i > 3 )) && i=0
			printf "\b\b\b"
		done
		printf "   \b\b\b"
	done
}
# }}}

# {{{ function passwd_prompt ()
# from AnNyung LInux
function passwd_prompt () {
	local prompt="$* : "
	unset _password

	# Disable echoing of characters and canonical mode for line buffering
	stty -echo -icanon

	while IFS= read -p "$prompt" -r -s -n 1 char
	do
		case "${char}" in
			$'\0')   # Enter
				break
				;;
			$'\x7f') # backspace case
				[[ -n ${_password} ]] && {
					# remove last * character that already printed
					printf "\b \b"
					# remove last character
					#[[ -n ${_password} ]] && _password="${_password:0:$(( ${#_password} - 1))}"
					_password="${_password%?}"
				}
				unset prompt
				;;
			$'\x04') # ctrl-D case
				unset _password
				break
				;;
			*)
				prompt='*'
				_password+="${char}"
		esac

	done
	echo

	stty echo icanon
}
# }}}

# {{{ function user_sudoer (USER)
function user_sudoer () {
    local user=$1
	local target

	[[ -z ${user} ]] && user="%wheel"

	[[ ${user:0:1} != "%" ]] && {
		getent passwd "${user}" >& /dev/null
		(( $? != 0 )) && return
	}

	if (( DRY == 0 )); then
		target=/etc/sudoers.d/${user//%/}
		[[ -f ${traget} ]] && return
	else
		target=/dev/null
	fi
	cat <<-EOL | sudo tee ${target}
		#
		# private sudoer configuration for ${user} account
		#

		Defaults env_keep += "WSL_DISTRO_NAME EDITOR"
		${user} ALL=(ALL:ALL) NOPASSWD: ALL
	EOL
}
# }}}

# {{{ function setAnsi (void)
# https://unix.stackexchange.com/questions/9957/how-to-check-if-bash-can-print-colors
function setAnsi () {
	[[ ! -t 1 ]] && [[ -n ${SSH_CLIENT} ]] && export TERM="xterm"

	# check if stdout is a terminal...
	if [[ -t 1 || ${TERM} == "xterm"* ]]; then

		# tput 을 설치하기 위해 ncurse 가 필요
		rpm -q --quiet ncurses || {
			echo
			echo -n "Installing Prerequisite Applications .. "
			dnf -y --setopt=skip_if_unavailable=True install ncurses >& /dev/null &
			spinner -1
			echo "Done"
			echo
		}

		# see if it supports colors...
		ncolors=$( tput colors )

		if [[ -n ${ncolors} ]] && (( ncolors >= 8 )); then
			bold="$(tput bold)"
			underline="$( tput smul )"
			revcolor="$(  tput smso )"
			normal="$(    TERM=ansi tput sgr0 )"
			black="$(     tput setaf 0 )"
			red="$(       tput setaf 1 )"
			green="$(     tput setaf 2 )"
			yellow="$(    tput setaf 3 )"
			blue="$(      tput setaf 4 )"
			magenta="$(   tput setaf 5 )"
			cyan="$(      tput setaf 6 )"
			white="$(     tput setaf 7 )"
			bgblack="$(   tput setab 0 )"
			bgred="$(     tput setab 1 )"
			bggreen="$(   tput setab 2 )"
			bgyellow="$(  tput setab 3 )"
			bgblue="$(    tput setab 4 )"
			bgmagenta="$( tput setab 5 )"
			bgcyan="$(    tput setab 6 )"
			bgwhite="$(   tput setab 7 )"
			bblack="${bold}${black}"
			bred="${bold}${red}"
			bgreen="${bold}${green}"
			byellow="${bold}${yellow}"
			bblue="${bold}${blue}"
			bmagenta="${bold}${magenta}"
			bcyan="${bold}${cyan}"
			bwhite="${bold}${white}"
		fi
	fi
}
setAnsi 2> /dev/null
# }}}

# {{{ function closeComment (void)
function closeComment () {
	(( is_reboot )) && {
		(( is_rhel9 != 1 )) && scmd="wsl -t ${WSL_DISTRO_NAME}" || scmd="wsl --shutdown"

		cat <<-EOL

			Complate configuration and the current session will close.
			Restart ${byellow}${WSL_DISTRO_NAME}${normal} and re-login ${bred}${DUSER}${normal} user with follow commands.

			    ${cyan}${scmd}
			    wsl -d ${WSL_DISTRO_NAME}${PUSER} --cd ${home:-${HOME}}${normal}

		EOL
		return
	}

	cat <<-EOL

		Complate configuration and the current session will close.
		Re-login ${bred}${USER}${normal} user with follow commands.

		    wsl -d ${WSL_DISTRO_NAME:-DISTRO_NAME} -u ${USER} --cd ${HOME}${normal}

	EOL
}
# }}}

DRY=${DRY:-0}

for i in /usr/share/Navix-WSL/*
do
	[[ ${i} == *"*" ]] && break
	source ${i} >& /dev/null
done

[[ $0 == "-bash" ]] && is_login_shell=1

# /bin/vi 가 없으면 처리해 주자

# 일반 유저일 경우, sudo 설정을 먼저 하자!
(( $UID != 0 )) && {
	echo " ${bwhite}** Set User sudoer configuration : ${bcyan}/etc/sudoer.d/${USER}${normal}"
	echo "   You ${cyan}need to give the password${normal} of the current account for sudo setting."
	echo
	user_sudoer ${USER}
	SUDO="sudo "
	clear
}

NAVIX="${bgreen}NAVIX${normal}"
WSL="${bmagenta}WSL${normal}"
cat <<-EOL
	${bwhite}Welcome to ${NAVIX}.${normal}

	Now you are the first login after configuring ${NAVIX} with the ${WSL} import environment.
	Proceed with additional settings for configuring the ${WSL} environment.

EOL

cat <<-EOL
	 ${bwhite}** CJKV (2byte) language support${normal}

	    1. Korean (ko)
	    2. Japanese (ja)
	    3. simplified Chinese (zh_CN)
	    4. Traditional Taiwanese (zh_TW)
	    5. Vietnamese (vi)
	    6. None
    
EOL

unset A
while [[ -z ${A} ]]
do
	echo -n "   Choise your select [1-6, default: 6] : "
	read A
	[[ -z ${A} ]] && A=6
	(( A == 0 || A > 6 )) && unset A
done

(( A != 6 )) && {
	case "${A}" in
		1) lo="ko"; loset="ko_KR" ;;
		2) lo="ja"; loset="ja_JP" ;;
		3) lo="zh_CN" ;;
		4) lo="zh_TW" ;;
		5) lo="vi"; loset="vi_VN" ;;
	esac

	echo -n "   installation ${byellow}${lo}${normal} locales .. "

	(( DRY == 0 )) && {
		${SUDO}dnf --setopt=skip_if_unavailable=True install -y langpacks-${lo} >& /dev/null &
		spinner -1
		rpm -q --quiet langpacks-${lo}
		if (( $? == 0 )); then
			echo "${bgreen}OK${normal}"

			cat <<-EOL | ${SUDO}tee /etc/locale.conf > /dev/null
				LANG="${loset:-${lo}}.utf8"
			EOL
		else
			echo "${bred}Failed${normal}"
			(( UID != 0 )) && {
				cat <<-EOL
					   ${bred}Installation of locale package failed${normal}.
					   You can continue by obtaining root privileges with the following commands.

					       ${bwhite}shell> sudo su -${normal}

				EOL
				echo "${USER}" > /dev/shm/init-user.txt
				[[ ! -f /mnt/wsl/distro.txt ]] &&
					echo "${WSL_DISTRO_NAME}" > /mnt/wsl/distro.txt 2> /dev/null

				(( is_login_shell == 1 )) && logout || exit 0
			}

			cat <<-EOL

				   ${bred}Installation of locale package failed${normal}.
				   Please after install langpacks-${lo} package manually with root privileges
				   and log in again.

				       ${bwhite}shell>${normal} dnf --setopt=skip_if_unavailable=True -y install langpacks-${lo}
				       ${bwhite}shell>${normal} cat <<-HERE > /etc/locale.conf
				       LANG="${loset:-${lo}}.utf8"
				       HERE

			EOL
			echo
		fi

	} || {
		echo "${bgreen}OK${normal}"
	}
	unset lo
}

systemd-wsl status >& /dev/null
(( $? != 0 )) && {
	cat <<-EOL

		 ${bwhite}** systemd Support${normal}

		   The NAVIX wsl image does not work in systemd mode.
		   If you want to start a particular service when you run wsl,
		   you need to operate in systemd mode.

		   Even if do not set it now, can do it again with the follow command later.

		      ${bmagenta}shell> systemd-wsl [on|off|status]${normal}

	EOL

	unset A
	while :
	do
		echo -n "   Do you want to use systemd? [y/n] : "
		read A
		case "${A}" in
			y|n)
				break
				;;
			*)
				unset A
		esac
	done

	[[ ${A,,} == "y" ]] && {
		# RHEL9 series including Navix 9 에서 systemd-logind 의 미완료 종료 문제 경고
		grep -q "release 9" /etc/redhat-release >& /dev/null
		(( $? == 0 )) && {
			is_rhel9=1
			cat <<-EOL

				   ${bred}[Warning]${normal}

				   In WSL2, when using systemd of RHEL9 series including Navix 9,
				   the wsl -t command may cause an incomplete shutdown of systemd-logind.
				   Therefore, please use the wsl --shutdown command instead of wsl -t,
				   or use the shutdown now command on the WSL Linux OS to shut down the system.

				   ${byellow}In conclusion${normal},
				   do not use ${bred}wsl -t${normal} to terminate,

				   but use for shutdown commands such as:

				      ${bcyan}wsl --shutdown${normal} or
				      ${bgreen}shell>${normal} ${bwyite}shutdown now${normal}

			EOL

			# "위의 메시지를 이해했으면, 계속 진행하기 위해 Enter 를 누르세요." 영어로 출력
			echo -n "   ${bmagenta}Press Enter${normal} to continue after understanding the above message .. "
			read A
			echo
			echo
		}

		(( DRY == 0 )) && systemd-wsl on >& /dev/null
		systemd-wsl status >& /dev/null
		if (( $? == 0 )); then
			mark="${bgreen}OK${normal}"
			is_reboot=1
		else
			mark="${bred}Fail${normal}"
		fi

		echo
		echo "   💡 systemd configuration .. ${mark}"
	}
}

if (( UID == 0 )); then

	echo
	# If there is no UID 1000, it is judged as the root login of the import environment.
	getent passwd 1000 >& /dev/null || {

		duser="$(
			grep --color=never -Eo "Users/[^/]+/AppData" <<< "${PATH}" \
				| awk -F '/' '{ print $2; exit; }'
		)"

		while [[ -z ${DUSER} ]]
		do
			echo -n "${bwhite} ** Add default login user${normal} [default is ${byellow}${duser}${normal}] : "
			read ANS
			[[ -z ${ANS} ]] && ANS="${duser}"
			! [[ ${ANS} =~ ^[A-Za-z] ]] || [[ ${ANS} =~ [^A-Za-z._\$-] ]] && continue
			DUSER=${ANS}; unset ANS
		done

		while :
		do
			passwd_prompt "${bwhite} ** Password${normal}"
			password1="${_password}"
			passwd_prompt "${bwhite} ** Password Confirm${normal}"
			password2="${_password}"

			[[ ${password1} == ${password2} ]] && break
			echo
			echo "    ${bred}Unmatched${normal} password. Input again."
			echo
			unset _password
		done

		echo -n "${bwhite} ** Create user ${DUSER}${normal} .. "

		_password="$( openssl passwd -6 "${_password}" )"
		(( DRY == 0 )) && {
			useradd --groups=adm,wheel,cdrom --password="${_password}" ${DUSER} >& /dev/null
			getent passwd ${DUSER} >& /dev/null && echo -n "${bgreen}OK" || echo -n "${bred}Fail${normal}"
		} || {
			echo "${bgreen}OK"
		}
		echo "${normal}"

		(( DRY == 0 )) && {
			[[ -f /etc/wsl.conf ]] && echo >> /etc/wsl.conf
			cat <<-EOL >> /etc/wsl.conf
				[user]
				default=${DUSER}
			EOL

			user_sudoer >& /dev/null
			home="$( getent passwd ${DUSER} | cut -d: -f6 )"
		}
	}

	if [[ -f /dev/shm/init-user.txt ]]; then
		DUSER="$( < /dev/shm/init-user.txt )"
		[[ -n ${DUSER} ]] && home="$( getent passwd ${DUSER} | cut -d: -f6 )"
		PUSER=" -u ${DUSER}"
		rm -f /dev/shm/init-user.txt >& /dev/null
		[[ -z ${WSL_DISTRO_NAME} && -f /mnt/wsl/distro.txt ]] &&
			WSL_DISTRO_NAME="$( < /mnt/wsl/distro.txt )"
	fi

	(( DRY == 1 )) && [[ -z ${home} ]] && home="/home/${DUSER}"

	is_reboot=1
	closeComment
else
	closeComment
fi

echo -n "${bwhite}Please input the Enter${normal} .."
read A

# Delete this file to prevent re-run on the next login.
#
# navix-wsl-firstboot 은 repository 가 없기 때문에 재실행 요청이 올 경우
# 대처가 필요하므로, 파일을 backup 시켜 놓고 지우자
if (( DRY == 0 )) && [[ -f /etc/profile.d/z-navix-wsl-firstboot.sh ]]; then
	[[ ! -d /usr/share/navix-wsl-firstboot ]] && mkdir -p /usr/share/navix-wsl-firstboot
	# backup 후에 실행 될 경우 예외 처리필요
	[[ -f /etc/profile.d/z-navix-wsl-firstboot.sh ]] && {
		cp -af /etc/profile.d/z-navix-wsl-firstboot.sh /usr/share/navix-wsl-firstboot/navix-wsl-firstboot.sh
		sed -ri '5i [[ $1 != react ]] && exit 0\n\n' /usr/share/navix-wsl-firstboot/navix-wsl-firstboot.sh
		chmod 644 /usr/share/navix-wsl-firstboot/navix-wsl-firstboot.sh
	}
fi
#
echo -n "${bwhite}Remove ${byellow}navix-wsl-firstroot${normal} package .. "
if (( DRY == 0 )); then
	${SUDO}dnf --setopt=skip_if_unavailable=True -y remove navix-wsl-firstboot >& /dev/null
	spinner -1
fi
echo "${bgreen}OK${normal}"
echo

(( DRY == 1 )) && exit 0
(( is_login_shell == 1 )) && logout || exit 0

#
# Embeded VIM Configurations
# vim: filetype=sh noet ts=4 sw=4 fdm=marker
#
