" quit when a vim configuration file was already loaded
if exists("g:did_load_vimrc")
	finish
endif

let g:did_load_vimrc = 1

if v:lang =~ "utf8$" || v:lang =~ "UTF-8$"
	if v:lang =~ "^ko"
		set fileencodings=ucs-bom,utf-8,cp949
	elseif v:lang =~ "^ja"
		set fileencodings=ucs-bom,utf-8,ujis
	elseif v:lang =~ "^zh_CN"
		set fileencodings=ucs-bom,utf-8,gbk
	elseif v:lang =~ "^zh_TW"
		set fileencodings=ucs-bom,utf-8,big5
	else
		set fileencodings=ucs-bom,utf-8,latin1
	endif
else
	if v:lang =~ "^ko"
		set fileencodings=cp949,utf-8,ucs-bom
	elseif v:lang =~ "^ja"
		set fileencodings=ujis,utf-8,ucs-bom
	elseif v:lang =~ "^zh_CN"
		set fileencodings=gbk,utf-8,ucs-bom
	elseif v:lang =~ "^zh_TW"
		set fileencodings=big5,utf-8,ucs-bom
	else
		set fileencodings=latin1,utf-8,ucs-bom
	endif
endif

set nocompatible        " Use Vim defaults (much better!)
set bs=indent,eol,start " allow backspacing over everything in insert mode
"set ai                 " always set autoindenting on
"set backup             " keep a backup file
set viminfo='20,\"50    " read/write a .viminfo file, don't store more
                        " than 50 lines of registers
set history=50          " keep 50 lines of command line history
set ruler               " show the cursor position all the time
set sw=4                " shiftwidth. width of auto indent
set ts=4                " tabstop. width of tab
set modeline
"set nopaste            " copy mode. adjust auto indent. If you don't want
                        " auto indent, set nopaste
"set number             " print line number

" Max tab size
set tabpagemax=30

" intelligent comments
set comments=sl:/*,mb:\ *,elx:\ */

" Don't use Ex mode, use Q for formatting
map Q gq

" for more support color
if &term =~ "xterm"
	"256 color --
	if has("gui_running")
		set termguicolors
		" Don't wake up system with blinking cursor:
		" http://www.linuxpowertop.org/known.php
		let &guicursor = &guicursor . ",a:blinkon0"
	endif
	if ! has('nvim')
		set term=xterm-256color
		set t_Co=256
	endif

	" restore screen after quitting
	"set t_ti=ESC7ESC[rESC[?47h t_te=ESC[?47lESC8
	if has("terminfo")
		let &t_Sf="\ESC[3%p1%dm"
		let &t_Sb="\ESC[4%p1%dm"
	else
		let &t_Sf="\ESC[3%dm"
		let &t_Sb="\ESC[4%dm"
	endif
endif

" Switch syntax highlighting on, when the terminal has colors
" Also switch on highlighting the last used search pattern.
if &t_Co > 2 || has("gui_running")
	syntax on
	" I like highlighting strings inside C comments.
	let c_comment_strings = 1
	set hlsearch
endif
"runtime syntax/syncolor.vim

" Disable both Beep sound and visual bell
if has("autocmd")
	autocmd VimEnter * set vb t_vb=
endif

"----------------------------------------------------------------------------------
" {{{ Development environments
"----------------------------------------------------------------------------------

" onmifunc use per file types
" ctrl+x ctrl+o or ctrl+n ctrl+p
"
filetype plugin indent on
if has("autocmd")
	autocmd CursorMovedI * if pumvisible() == 0|pclose|endif
	autocmd InsertLeave * if pumvisible() == 0|pclose|endif
endif
"set omnifunc=javacomplete#Complete
"set completefunc=javacomplete#CompleteParamsInfo

set splitbelow
set splitright

set foldmethod=marker
" for search 5th depth
set tags=./tags,tags
set tags+=../tags,../../tags,../../../tags
set tags+=../../../../tags,../../../../../tags
set tags+=/usr/share/php/pear/tags
set tags+=/usr/include/tags

" Make sure help set properly for perl files
autocmd FileType perl set kp=perldoc\ -f

" nvim don't have global vim configuration
if has("nvim")
	" Do incremental searching when it's possible to timeout.
	if has('reltime')
		set incsearch
	endif

	if has("autocmd")
		augroup redhat
			autocmd!
			" In text files, always limit the width of text to 78 characters
			autocmd BufRead *.txt set tw=156
			" When editing a file, always jump to the last cursor position
			autocmd BufReadPost *
				\ if line("'\"") > 0 && line ("'\"") <= line("$") |
				\   exe "normal! g'\"" |
				\ endif
			" don't write swapfile on most commonly used directories for NFS mounts or USB sticks
			autocmd BufNewFile,BufReadPre /media/*,/run/media/*,/mnt/* set directory=~/tmp,/var/tmp,/tmp

			" start with spec file template
			" In redhat compatible distributions, this setting is sometimes added in sysvinit.vim.
			" If template.spec is duplicate output, annotate the use_rpm_spec_template setting.
			"let use_rpm_spec_template = 1
			if exists("use_rpm_spec_template")
				if filereadable(expand("~/.vim/template.spec"))
					autocmd BufNewFile *.spec silent! 0r ~/.vim/template.spec
				elseif filereadable(expand("~/.config/nvim/template.spec"))
					autocmd BufNewFile *.spec silent! 0r ~/.config/nvim/template.spec
				else
					autocmd BufNewFile *.spec silent! 0r /usr/share/vim/vimfiles/template.spec
				endif
			endif
		augroup END

		augroup cprog
			" Remove all cprog autocommands
			au!

			" When starting to edit a file:
			"   For C and C++ files set formatting of comments and set C-indenting on.
			"   For other files switch it off.
			"   Don't change the order, it's important that the line with * comes first.
			autocmd FileType *      set formatoptions=tcql nocindent comments&
			autocmd FileType c,cpp  set formatoptions=croql cindent comments=sr:/*,mb:*,el:*/,://
		augroup END
	endif

	if has("cscope") && filereadable("/usr/bin/cscope")
		set csprg=/usr/bin/cscope
		set csto=0
		set cst
		set nocsverb
		" add any database in current directory
		if filereadable("cscope.out")
			cs add cscope.out
		" else add database pointed to by environment
		elseif $CSCOPE_DB != ""
			cs add $CSCOPE_DB
		endif
		set csverb
	endif
endif

" End of Development environments }}}

"----------------------------------------------------------------------------------
" {{{ Plugin call
"----------------------------------------------------------------------------------
call plug#begin('~/.config/nvim/plugged')
"Plug 'vim-airline/vim-airline'
"Plug 'vim-airline/vim-airline-themes'
call plug#end()
" End of Plugin call }}}

"**********************************************************************************
" {{{ Plugin config
"**********************************************************************************

"----------------------------------------------------------------------------------
" {{{ VIM airline
"----------------------------------------------------------------------------------

" if you don't want to use ariline, set g:loaded_airline options to 1
let g:loaded_airline = 0

" recommended theme is minimalist, violet, raven, understated
" see also can see other theme to
" https://github.com/vim-airline/vim-airline/wiki/Screenshots
"let g:airline_theme = 'bubblegum'
let g:airline_theme = 'violet'
let g:airline_powerline_fonts = 1
let g:airline#extensions#tabline#enabled = 1
let g:airline#extensions#tabline#formatter = 'unique_tail'
let g:airline#extensions#tabline#fnamemod = ':t'

" End of VIM airline }}}

"----------------------------------------------------------------------------------
" {{{ VIM TabDistinct
"----------------------------------------------------------------------------------

" Mapping Distinct between TAB and SPACE character
map _ :call TabDistinct ()<cr>

" End of VIM TabDistinct }}}

"----------------------------------------------------------------------------------
" {{{ VIM checksyntax
"----------------------------------------------------------------------------------

" if failed, move cursor to fault window
let g:checksyntax#movewindow = 1
" 저장 후,  수동 검사
let g:checksyntax#postwrite  = 1

" End of VIM CheckSyntax }}}
"
" End of Plugin config }}}
